﻿using inetsoftware.Config;
using inetsoftware.ProcessBridge;
using inetsoftware.Reporting;
using System;
using System.Collections.Generic;

namespace inetsoftware
{
    /// <summary>
    /// This sample prints a rpt file to a printer.
    /// </summary>
    public class SimplePrint
    {
        static SimplePrint()
        {
            // set license once from environment if required.
            string license = Environment.GetEnvironmentVariable("ICR_LICENSE");
            if (!string.IsNullOrEmpty(license))
            {
                ConfigurationManager.Instance.Current["licensekey"] = license;
            }
        }

        public static void Main(string[] args)
        {
            Engine eng = new Engine(""); // we need the data in the java format, so no export format
            List<string> availablePrinters = eng.GetAvailablePrinters();

            eng.ReportFile = @"samples\resources\Sample.rpt";
            try
            {
                eng.Print(availablePrinters[0]); // we use the first printer
            }
            catch(ProcessException )
            {
                // there was an exception while printing.
            }

        }
    }
}
